#!/usr/bin/perl

$Modified = 0 ;
$XGIVendorName = "XGI Technology Inc." ;
$TargetDevID = "XGIGraphic" ;
$TargetDrvSectionFound = 0 ;
$NonXGITargetDrvExist = 0;

@params = @ARGV;

#print STDERR "@params\n";

#
# arg1 = Xorg or XFree86 configure filename
# arg2 = Xorg or XFree86 configure backup filename
# arg3 = XGI adapter name
# arg4 = XGI 2d driver name
#


$arg1 = shift(@params) ;
$arg2 = shift(@params) ;
$arg3 = shift(@params) ;
$arg4 = shift(@params) ;

#print STDERR "$arg1, $arg2\n";

if ( ($arg1 ne "") && ( $arg2 ne "") ) {
	$src = $arg1;
	$bak = $arg2;
} else {
	$src = "/etc/X11/XF86Config" ;
	$bak = "/etc/X11/.XF86Config.bak" ;
}

if ($arg3 ne "") {
	$TargetBoardName = "XGI Volari $arg3";
} else {
    $TargetBoardName = "XGI Volari Graphic Adapter" ;
}

if ($arg4 ne "") {
	$TargetDrvID = $arg4;
} else {
    $TargetDrvID = "xgi" ;
}

#if ( ! -f $src ) {
#	$src = "/etc/X11/xorg.conf" ;
#	$bak = "/etc/X11/.xorg.conf.bak" ;
#	if ( ! -f $src ) {
#		$src = "/etc/X11/XF86Config-4" ;
#		$bak = "/etc/X11/.XF86Config-4.bak" ;			
#	}
#}

#print STDERR "$src, $bak\n";

if ( ! -f $src ) {
	die "Cannot find X Configuration File $src" ;
	exit(0) ;
}

$tmp = "/tmp/XF86Config.$$" ;

open( SRC , "$src" ) || die "Cannot open Xfree86 config file $src.\n" ;
$DeviceSection = 0 ;
while(<SRC>)
{
	$ln = $_ ;
	$ln =~ s/^\s+//g ;	# remove the blank of line
	$ln =~ s/#.*$//g ;
	$ln =~ s/\s+$//g ;
	$ln =~ s/\s+/ /g ;

	if( $ln =~ m/Section "ServerLayout"/ ){
		$ServerLayOutSection = 1 ;
	}

	if( $ln =~ m/Section "Device"/ ){
		$DeviceSection = 1 ;
	}

	if( $ServerLayOutSection )
	{
		if( $ln =~ m/Screen "(.*)"/ )
		{
			$ScreenIdentifier = $1 ;
		}
		elsif( $ln =~ m/Screen \d+ "(.*)"/ )
		{
			$ScreenIdentifier = $1 ;
		}
	}

	if( $DeviceSection ) 
	{
		if( $ln =~ m/Identifier "(.*)"/ )
		{
			$DevID = $1 ;
		}
		if( $ln =~ m/Driver "(.*)"/ )
		{
			$DrvID = $1 ;
		}
	}

	if( $ln =~ m/EndSection/ ){
		$ServerLayOutSection = 0 ;

		if( $DeviceSection )
		{
			$DrvForDev{$DevID} = $DrvID ;
			
			if( $DrvID eq $TargetDrvID )
			{
				$TargetDevID = $DevID ;
				$TargetDrvSectionFound = 1 ;
			} else {
				$NonXGITargetDrvExist = 1;
			}

			$DrvID = "" ; $DevID = "" ;
		}
		$DeviceSection = 0 ;
	}

}
close(SRC) ;

open( SRC , "$src" ) || die "Cannot open X config file $src.\n" ;
if ( !open( TMP , ">$tmp" ) ){
	close(SRC) ;
	die "cannot open temp file $tmp\n" ;
}

while(<SRC>)
{
	$ln = $_ ;
	$ln =~ s/^\s+//g ;	# remove the blank of line
	$ln =~ s/#.*$//g ;
	$ln =~ s/\s+$//g ;
	$ln =~ s/\s+/ / ;

	if( $ln =~ m/Section "Screen"/) {
		$ScreenSection = 1 ;
		$ScreenSectionStr = "" ;
		$scrid = "" ;
		$devid = "" ;
		$DeviceNotExist = 1 ;
	}
	
	if( $ln =~ m/Section "Device"/) {
		$DeviceSection = 1;
	}


	if( $ScreenSection )
	{
		if( $ln =~ m/Identifier "(.*)"/ ){
			$scrid = $1 ;
			if( $scrid eq $ScreenIdentifier ){
				$found = 1 ;
			}
		}elsif($ln =~ m/Device "(.*)"/ ){
			$DeviceNotExist = 0 ;
			$devid = $1 ;
		}

		$ScreenSectionStr = "$ScreenSectionStr$_" ;
		$_ = "" ;
	}
	
	if( $DeviceSection ) {
		if ( $NonXGITargetDrvExist ) {
			#$_ = "\#$_";
		}
	}

	if( $ln =~ m/EndSection/ ) 
	{
		if( $DeviceSection )
		{
			if ( $NonXGITargetDrvExist ) {
				
				$NonXGITargetDrvExist = 0;
			}
			$DeviceSection = 0;
			#$_ = "\#$_";
		}

		if( $ScreenSection )
		{

			if( $found )
			{
				if( $DrvForDev{$devid} eq "$TargetDrvID" )
				{
					$found = 0 ; 
					printf( STDERR "Current Device %s uses driver \"%s\"(%s_drv.o), no need to update $src.\n"
						,$devid , $DrvForDev{$devid} , $DrvForDev{$devid}) ;
					# old driver found, do nothing.
				}
				elsif( $DeviceNotExist ) 
				{
					printf( STDERR "No device in Screen Section, add new device ID %s\n",${TargetDevID} ) ;
					$ScreenSectionStr =~ s/(\n\s*EndSection)/\n\tDevice\t"${TargetDevID}"$1/g ;
					$Modified = 1 ;
				}
				else
				{
					printf( STDERR "Replace device \"%s\" with \"%s\"\n",$devid,$TargetDevID) ;
					$ScreenSectionStr =~ s/(Device\s+)"([^"]*)"/$1"${TargetDevID}"/g ;
					$Modified = 1 ;
				}
			}

			if( $found ){
				if( $TargetDrvSectionFound == 0 )
				{
					$str = "" ;
					$str = "${str}Section \"Device\"\n" ;
					$str = "${str}    Identifier  \"${TargetDevID}\"\n" ;
					$str = "${str}    BoardName   \"${TargetBoardName}\"\n" ;
					$str = "${str}    VendorName  \"${XGIVendorName}\"\n" ;
					$str = "${str}    Driver      \"${TargetDrvID}\"\n" ;
					$str = "${str}EndSection\n\n" ;
					$ScreenSectionStr = "${str}$ScreenSectionStr" ;
					$Modified = 1 ;
				}
				$found = 0 ;
			}

			$_ = $ScreenSectionStr ;
		}
		$ServerLayOutSection = 0 ;
		$ScreenSection = 0 ;
	}

	print( TMP "$_" ) ;
}
close( TMP ) ;
close( SRC ) ;

if( $Modified ){
	printf( STDERR "X Configure file was updated.\n") ;

	if (! -f $bak ) {
		system( "mv $src $bak" ) ;
	}
	
	# system( "/bin/cp $tmp ." ) ;
	system( "mv $tmp $src" ) ;
}
else
{
	printf( STDERR "Configuration File %s contains usable setting, no update need.\n",$src ) ;
}
