#!/bin/sh

SYSTEM=`uname -s`
CURRENTDATE=`date +%F-%H-%M-%N`
echo
echo "XGI $SYSTEM driver installation for package `cat version`"
echo 

#############################################
## 0. Get the distribution information
#############################################
Distrib_SE="/etc/SuSE-release"
Distrib_MD="/etc/mandrake-release"
Distrib_FC="/etc/fedora-release"
Distrib_RF="/etc/redflag-release"
Distrib_RH="/etc/redhat-release"
Distrib_TB="/etc/turbolinux-release"
Distrib_SL="/etc/slackware-version"
Distrib_UB="/etc/lsb-release"
Distrib="other"

#check OS
if [ -f $Distrib_RF ] ; then
	Distrib="redflag"
elif [ -f $Distrib_MD ] ; then
	Distrib="mandrake"
elif [ -f $Distrib_FC ] ; then
	Distrib="fedora"         
	fedora7=`grep -i "Fedora release 7" /etc/fedora-release |cut -d ' ' -f3`
elif [ -f $Distrib_SE ] ; then
	Distrib="suse"
elif [ -f $Distrib_RH ] ; then
	Distrib="redhat" 
elif [ -f $Distrib_TB ] ; then
	Distrib="turbolinux" 
elif [ -f $Distrib_UB ] ; then
	Distrib="ubuntu" 
elif [ -f $Distrib_SL ] ; then
	Distrib="Slackware"
	Slackware12=`grep -i "Slackware" /etc/slackware-version |cut -d ' ' -f2`
elif [ $SYSTEM = "FreeBSD" ] ; then
	Distrib="FreeBSD" 

else 
	Distrib="other"
fi

echo $Distrib


if [ $Distrib = "Slackware" ] ; then                                                              
   config=/etc/X11/.xorg.conf.xgi                                                               
  if [ -f $config ] ; then                                                                      
      echo "Driver has alreday setup, Please make uninstall first and then reinstallate."       
      exit 0              
  else
      sh install_slackware.sh                                                                      
   fi   
                                                                                       
elif [ $Distrib = "ubuntu" ] ; then                                                              
   config=/etc/X11/.xorg.conf.xgi                                                               
  if [ -f $config ] ; then                                                                      
      echo "Driver has alreday setup, Please make uninstall first and then reinstallate."       
      exit 0              
  else
      sh install_ubuntu.sh                                                                      
   fi   
                                                                                       

else                                                                                            
  configother=/etc/X11/.xorg.conf.xgi                                                           
  if [ -f $configother ] ; then                                                                 
     echo "Driver has alreday setup, Please make uninstall first and then reinstallate."        
     exit 0                  
  else
      sh install_nor.sh
  fi                                                                                            
fi                                                                                              
                                                                                                



