#!/bin/sh

SYSTEM=`uname -s`
CURRENTDATE=`date +%F-%H-%M-%N`
echo
echo "XGI $SYSTEM driver installation for package `cat version`"
echo

#############################################
## 0. Get the distribution information
#############################################
Distrib_SE="/etc/SuSE-release"
Distrib_MD="/etc/mandrake-release"
Distrib_FC="/etc/fedora-release"
Distrib_RF="/etc/redflag-release"
Distrib_RH="/etc/redhat-release"
Distrib_TB="/etc/turbolinux-release"
Distrib_UB="/etc/lsb-release"
Distrib="other"

#check OS
if [ -f $Distrib_RF ] ; then
        Distrib="redflag"
elif [ -f $Distrib_MD ] ; then
        Distrib="mandrake"
elif [ -f $Distrib_FC ] ; then
        Distrib="fedora"
        fedora7=`grep -i "Fedora release 7" /etc/fedora-release |cut -d ' ' -f3`
        fedora8=`grep -i "Fedora release 8" /etc/fedora-release |cut -d ' ' -f3`
#	echo $fedora7
#        echo $fedora8
elif [ -f $Distrib_SE ] ; then
        Distrib="suse"
elif [ -f $Distrib_RH ] ; then
        Distrib="redhat"
elif [ -f $Distrib_TB ] ; then
        Distrib="turbolinux"
elif [ -f $Distrib_UB ] ; then
        Distrib="ubuntu"
	ubuntu804=`grep -i "DISTRIB_RELEASE=8.04" /etc/lsb-release |cut -d ' ' -f2`
elif [ $SYSTEM = "FreeBSD" ] ; then
A
        Distrib="FreeBSD"
else
        Distrib="other"
fi

echo $Distrib

XSERVER_MODULE="XFree86"

XFREE86_CFG="/etc/X11/XF86Config"
XFREE86_BAK="/etc/X11/.XF86Config.bak"

XORG_CFG="/etc/X11/xorg.conf"
#XORG_BAK="/etc/X11/.xorg.conf.bak"
XORG_BAK="/etc/X11/.xorg.conf.xgi"

RF_XFREE86_CFG="/etc/X11/XF86Config-4"
RF_XFREE86_BAK="/etc/X11/.XF86Config-4.bak"

CFG=$XFREE86_CFG
BAK=$XFREE86_BAK

if [ -f $XFREE86_CFG ] ; then
	CFG=$XFREE86_CFG
	BAK=$XFREE86_BAK
	XSERVER_MODULE="XFree86"
fi

if [ -f $XORG_CFG ] ; then
	CFG=$XORG_CFG
	BAK=$XORG_BAK
	XSERVER_MODULE="XOrg"
fi

if [ -f $RF_XFREE86_CFG ] ; then
	CFG=$RF_XFREE86_CFG
	BAK=$RF_XFREE86_BAK
	XSERVER_MODULE="XFree86"
fi

driver_bin="xgiz_drv.o"
driver_share_bin="xgiz_drv.so"
# check FreeBSD for claire 2007/03/20
SYSTEM=`uname -s`
if [ $SYSTEM = "FreeBSD" ] ; then
	FreeBSDVer=`uname -r`
	if [ $FreeBSDVer = "6.1-RELEASE" ] || [ $FreeBSDVer = "6.2-RELEASE" ]; then
	 driver_bin="xgiz_drv.so"
        elif [ $FreeBSDVer = "7.0-RELEASE" ]; then
		driver_bin="xgiz_drv.so"
	fi

else
#X -version 2&>/root/xgi.log
#Ver=`grep -i "X Window System Version" /root/xgi.log |cut -d ' ' -f5`
Ver=`grep -i "X Window System Version" /var/log/Xorg.0.log |cut -d ' ' -f5`
V=`echo $Ver |cut -d '.' -f1`
V1=`echo $Ver |cut -d '.' -f2`
if [ ${#V} -gt 0 ]; then
	if [ $V -ge 7 ] || [ $V -ge 1 ]; then
   	X11R7=/usr/lib/xorg/modules/drivers
	fi
	# for support OS:puppy, claire add 2007/04/23 
	if [ Distrib = "other" ] ; then
   		X11R7=/usr/X11R7/lib/xorg/modules/drivers
	fi

else
	if [ ${#V} -gt 0 ] ; then
	   if [ $V -ge 1 ] ; then	
      	    X11R7=/usr/lib/xorg/modules/drivers
		driver_path=${X11R7}
           fi
	fi

	if [ ${#ubuntu804} -gt 0 ] ; then
      	    X11R7=/usr/lib/xorg/modules/drivers
		driver_path=${X11R7}
        fi




	
	if [ ${#fedora7} -gt 0 ] ; then
	   if [ $fedora7 -ge 7 ] ; then	
      	    X11R7=/usr/lib/xorg/modules/drivers
		driver_path=${X11R7}
           fi
	fi

	if [ ${#fedora8} -gt 0 ] ; then
            echo $fedora8
	   if [ $fedora8 -ge 8 ] ; then	
      	    X11R7=/usr/lib/xorg/modules/drivers
		driver_path=${X11R7}
           fi
	fi
fi
fi

if [ "$X11R6" = "" ] ; then
	# echo "The system do not contains the X11R6 environment variable." 1>&2
	# echo "Use /usr/X11R6 as default X11R6 path." 1>&2
	# echo
	# echo
	X11R6=/usr/X11R6
	export X11R6
fi

if [ "$MACHTYPE" = "" ] ; then
	MACHTYPE=i386
fi

MACH=`echo $MACHTYPE | sed 's/-.*$//g'` ;

if [ "$MACH" = "x86_64" ] ; then
	# 64 bit

	driver_path=${X11R6}/lib64/modules/drivers
        if [ ${#V} -gt 0 ] ; then 
           if [ $V -ge 7 ] ; then
              X11R7=/usr/lib64/xorg/modules/drivers
              driver_path=$X11R7
              driver_bin="xgiz_drv.so"
           elif [ $V -ge 6 ] ; then
              driver_bin="xgiz_drv.so" 
           fi
        fi
        if [ ${#fedora7} -gt 0 ] ; then
           if [ $fedora7 -ge 7 ] ; then
            X11R7=/usr/lib64/xorg/modules/drivers
                driver_path=${X11R7}
           fi
        fi

        if [ ${#fedora8} -gt 0 ] ; then
           if [ $fedora8 -ge 8 ] ; then
            X11R7=/usr/lib64/xorg/modules/drivers
                driver_path=${X11R7}
           fi
        fi

	if [ ! -d $driver_path ] ; then
		driver_path=${X11R6}/lib/modules/drivers
	fi
else
	# 32 bit
	driver_path=${X11R6}/lib/modules/drivers
	#### 2008/07/09 claire add for uninstall FreeBSD 7.0 (Xorg 1.4.0)
	if [ $SYSTEM = "FreeBSD" ] ; then
	#	FreeBSDVer=`uname -r`
		if [ $FreeBSDVer = "7.0-RELEASE" ] ; then
			driver_path=${X11R6}/lib/xorg/modules/drivers
		fi
	fi

	### claire 2008/07/10 add for support ubuntu8.04
	if [ ${#ubuntu804} -gt 0 ] ; then
      	    X11R7=/usr/lib/xorg/modules/drivers
		driver_path=${X11R7}
        fi






	if [ ${#V} -gt 0 ]; then
		if [ $V -ge 7 ] || [ $V -ge 1 ]; then
	  	   driver_path=${X11R7}
      	   	 X11R7=/usr/lib/xorg/modules/drivers
		fi
	fi


	if [ ${#fedora7} -gt 0 ] ; then
	   if [ $fedora7 -ge 7 ] ; then	
      	    X11R7=/usr/lib/xorg/modules/drivers
		driver_path=${X11R7}
           fi
	fi

	if [ ${#fedora8} -gt 0 ] ; then
	   if [ $fedora8 -ge 8 ] ; then	
      	    X11R7=/usr/lib/xorg/modules/drivers
		driver_path=${X11R7}
           fi
	fi

fi


DRV="${driver_path}/$driver_bin"
DRV_SHARE="${driver_path}/$driver_share_bin"

if [ ! -d "$driver_path" ] ; then
	echo "Cannot open X11 installation path $driver_path. Exit." 1>&2
	exit -1 ;
fi



echo "Uninstall XGI $XSERVER_MODULE driver (Y/N)?"
read RESULT
if [ "${RESULT}" = "Y" -o "${RESULT}" = "y" ]; then
	if [ $SYSTEM != "FreeBSD" ] ; then
            if [ $Distrib = "suse" ] ; then
	        cp -a /etc/X11/.xorg.conf.xgi /etc/X11/xorg.conf       
		rm -rf /etc/X11/.xorg.conf.xgi
	    else      
		if [ ${#V} -gt 0 ] ; then
		        if [ $V -ge 7 ] || [ $V -ge 1 ] ; then
          			cp -a /etc/X11/.xorg.conf.xgi /etc/X11/xorg.conf
		                rm -rf /etc/X11/.xorg.conf.xgi
		        elif [ $V -ge 6 ] ; then
        	   	    if [ $V1 -ge 9 ] ; then
	        		cp -a /etc/X11/.xorg.conf.xgi /etc/X11/xorg.conf       
				rm -rf /etc/X11/.xorg.conf.xgi
	       		    fi  
			else
				cp -a /etc/X11/.xorg.conf.xgi /etc/X11/xorg.conf
				rm -rf /etc/X11/.xorg.conf.xgi
         		fi
       		fi
          	if [ ${#ubuntu804} -gt 0 ] ; then 
			cp -a /etc/X11/.xorg.conf.xgi /etc/X11/xorg.conf
			rm -rf /etc/X11/.xorg.conf.xgi

		fi 
	     fi
           
     	else
                #echo $fedora7
     		cp /etc/X11/.xorg.conf.xgi /etc/X11/xorg.conf
		rm -rf /etc/X11/.xorg.conf.xgi
     	fi   
      
	if [ -f "${DRV}" ] ; then
		/bin/rm ${DRV}
		echo "${DRV} is removed."
	fi

	if [ -f "${DRV_SHARE}" ] ; then
		/bin/rm ${DRV_SHARE}
		echo "${DRV_SHARE} is removed."
	fi
fi
