#!/bin/sh

SYSTEM=`uname -s`
CURRENTDATE=`date +%F-%H-%M-%N`
echo
echo "XGI $SYSTEM driver installation for package `cat version`"
echo 

#############################################
## 0. Get the distribution information
#############################################
Distrib_SE="/etc/SuSE-release"
Distrib_MD="/etc/mandrake-release"
Distrib_FC="/etc/fedora-release"
Distrib_RF="/etc/redflag-release"
Distrib_RH="/etc/redhat-release"
Distrib_TB="/etc/turbolinux-release"
Distrib="other"

#check OS
if [ -f $Distrib_RF ] ; then
	Distrib="redflag"
elif [ -f $Distrib_MD ] ; then
	Distrib="mandrake"
elif [ -f $Distrib_FC ] ; then
	Distrib="fedora"
	fedora7=`grep -i "Fedora release " /etc/fedora-release |cut -d ' ' -f3`
elif [ -f $Distrib_SE ] ; then
	Distrib="suse"
elif [ -f $Distrib_RH ] ; then
	Distrib="redhat" 
elif [ -f $Distrib_TB ] ; then
	Distrib="turbolinux" 
elif [ $SYSTEM = "FreeBSD" ] ; then
	Distrib="FreeBSD" 

else 
	Distrib="other"
fi

echo $Distrib
#############################################
## 1. Copy 2D driver
#############################################
driver_bin="xgiz_drv.o"
driver_share_bin="xgiz_drv.so"

if [ $Distrib = "FreeBSD" ] ; then
   FreeBSDVer=`uname -r`
   echo $FreeBSDVer
   if [ $FreeBSDVer = "6.1-RELEASE" ] || [ $FreeBSDVer = "6.2-RELEASE" ] ; then
      cp xgiz_drv.so.70 xgiz_drv.so
      driver_bin="xgiz_drv.so"
   elif [ $FreeBSDVer = "7.0-RELEASE" ] ; then
	cp xgiz_drv.so.73 xgiz_drv.so
	driver_bin="xgiz_drv.so" 
   fi

else 
if [ ! -d xgiz_drv.so ] ; then
	cp -a xgiz_drv.so.70  xgiz_drv.so
fi

X -version 2&>/root/xgi.log
Ver=`grep -i "X Window System Version" /root/xgi.log|cut -d ' ' -f5`
V=`echo $Ver|cut -d '.' -f1`
V1=`echo $Ver|cut -d '.' -f2`
if [ ${#V} -gt 0 ]; then
	if [ $V -ge 7 ] ; then
   	X11R7=/usr/lib/xorg/modules/drivers
   	# for support OS:puppy, claire add 2007/04/23 
	if [ Distrib = "other" ] ; then
   		X11R7=/usr/X11R7/lib/xorg/modules/drivers
	fi
            if [ ${#V1} -gt 0 ] ; then
                if [ $V1 -ge 0 ] ; then
                   cp -a xgiz_drv.so.70 xgiz_drv.so
              	fi
                if [ $V1 -ge 1 ] ; then
                   cp -a xgiz_drv.so.71 xgiz_drv.so
 		fi
		if [ $V1 -ge 2 ] ; then
		  cp -a xgiz_drv.so.72 xgiz_drv.so
		fi
            fi
        elif [ $V -ge 6 ] ;then
             if [ $V1 -ge 9 ] ; then
		X11R7=/usr/lib/xorg/modules/drivers
		
	     fi
	fi

if [ ${#fedora7} -gt 0 ] ; then
	if [ $fedora7 -ge 7 ] ; then
	   cp -a xgiz_drv.so.72 xgiz_drv.so
	   X11R7=/usr/lib/xorg/modules/drivers
	fi

fi
  


fi
fi


if [ "$X11R6" = "" ] ; then
	# echo "The system do not contains the X11R6 environment variable." 1>&2
	# echo "Use /usr/X11R6 as default X11R6 path." 1>&2
	# echo
	# echo
	X11R6=/usr/X11R6
	export X11R6
fi

if [ "$MACHTYPE" = "" ] ; then
	MACHTYPE=i386
fi

MACH=`echo $MACHTYPE | sed 's/-.*$//g'` ;

if [ "$MACH" = "x86_64" ] ; then
	# 64 bit
	driver_path=${X11R6}/lib64/modules/drivers
	if [ ${#V} -gt 0 ] ; then
	   if [ $V -ge 7 ] ; then
		X11R7=/usr/lib64/xorg/modules/drivers
		driver_path=${X11R7}
		driver_bin="xgiz_drv.so"
	   elif [ $V -ge 6 ] ; then
		if [ $V1 -ge 9 ] ;then
		driver_bin="xgiz_drv.so"
                fi
           fi
        fi
         if [ ${#fedora7} -gt 0 ] ; then
            if [ $fedora7 -ge 7 ] ;then
		X11R7=/usr/lib64/xorg/modules/drivers
                driver_path=${X11R7}
                driver_bin=xgiz_drv.so
            fi
         fi

       
	if [ ! -d $driver_path ] ; then
		driver_path=${X11R6}/lib/modules/drivers
	fi
else
	# 32 bit	
	 driver_path=${X11R6}/lib/modules/drivers
	### 2008/07/09 claire add for support FreeBSD 7.0 (xorg 1.4.0)
   if [ $FreeBSDVer = "7.0-RELEASE" ] ; then
	 driver_path=${X11R6}/lib/xorg/modules/drivers

   fi
   if [ ${#V} -gt 0 ] ; then
	if [ $V -ge 7 ] ; then
         driver_path=${X11R7}
    	 driver_bin="xgiz_drv.so"
	elif [ $V -ge 6 ] ; then
           if [ $V1 -ge 9 ] ; then
         	driver_bin="xgiz_drv.so"
           fi
    	 fi
    fi

    if [ ${#fedora7} -gt 0 ] ; then
	  if [ $fedora7 -ge 7 ] ;then
		driver_path=${X11R7}
		driver_bin=xgiz_drv.so
	  fi
    fi
fi
rm -rf /root/xgi.log

DRV="${driver_path}/$driver_bin"
SHARE_DRV="${driver_path}/$driver_share_bin"

if [ ! -d "$driver_path" ] ; then
	echo "Cannot open X11 installation path $driver_path. Exit." 1>&2
	exit -1 ;
fi

if [ -f $driver_bin ] ; then 
	install -m 644 $driver_bin $driver_path
	echo "Driver $driver_bin copy to ${driver_path} done."
else
	echo "There is no $driver_bin existing." 1>&2
	exit -1 ;
fi

if [ "$Distrib" = "turbolinux"  ]; then
	TB_version=`cat $Distrib_TB| grep ^Turbolinux | cut -d ' ' -f3`
	if [ $TB_version > 11 ] || [ $TB_version = 11 ]; then
		if [ -f $driver_share_bin ] ; then 
			install -m 644 $driver_share_bin $driver_path
			echo "Driver $driver_share_bin copy to ${driver_path} done."
		else
			echo "There is no $driver_share_bin existing." 1>&2
			exit -1 ;
		fi
	fi
fi

# Probe HW and generate /etc/sysconfig/hwconf
if [ -f /usr/sbin/kudzu ] ; then
	kudzu -q
fi

################################################
## 2. Get XGI chip information
################################################
#
# Get register info.to check if the current 
# adapter is XG20 or XG21, 2005/11/1, JILL
#

XGICards="Cards.xgi"
XGIPCI="pcitable.xgi"
XGICards_SUSE="Cards.xgi.suse"
XGIIdentity="Identity.xgi"
#echo $XGICards
#echo "claire"

if [ $Distrib != "FreeBSD" ] ; then 

	lspci -n >/root/xgichip.log
	#b=`grep -i "18ca:0020" /root/xgichip.log|cut -d ' ' -f3`
	#c=`grep -i "18ca:0027" /root/xgichip.log|cut -d ' ' -f3`

	b=`grep -i "18ca:0020" /root/xgichip.log`
	c=`grep -i "18ca:0027" /root/xgichip.log`
	d=`grep -i "18ca:0021" /root/xgichip.log`
	#echo $b
else
	XGICards="Cards_Freebsd.xgi"
	XGIPCI="pcitable_Freebsd.xgi"
	XGIIdentity="Identity_Freebsd.xgi"
#echo $XGICards
#echo "claire freebsd"
fi


if [ $Distrib != "FreeBSD" ] ; then 
	if [ ${#b} -gt 0 ] ; then
		#if [ $b = "18ca:0020" ] ; then
		XGICards="Cards_21.xgi"
		XGIPCI="pcitable_21.xgi"
		XGICards_SUSE="Cards_21.xgi.suse"
		XGIIdentity="Identity_21.xgi"
	fi
	if [ ${#d} -gt 0 ] ; then
		#if [ $b = "18ca:0021" ] ; then
		XGICards="Cards_21.xgi"
		XGIPCI="pcitable_21.xgi"
		XGICards_SUSE="Cards_21.xgi.suse"
		XGIIdentity="Identity_21.xgi"
	fi

	if [ ${#c} -gt 0 ] ; then
	#if [ $c = "18ca:0027" ] ; then
		XGICards="Cards_27.xgi"
		XGIPCI="pcitable_27.xgi"
		XGICards_SUSE="Cards_27.xgi.suse"
		XGIIdentity="Identity_27.xgi"

	fi
	#echo $b
	#echo $c

fi


################################################
## 3. modify configuration
################################################

##
# If Redhat or Fedora, Begin
##

if [ "$Distrib" = "redhat" ] || [ "$Distrib" = "fedora" ] ; then

	# Jill, 2006/08/15, modify for Fedora core 5(Xorg 7.0), 
	# use system-config-display only for xorg 6.8.2
        if [ "$V" != "7" ]; then
	    if [ -f /etc/X11/xorg.conf ] ; then

		if [ "$Distrib" = "redhat" ] ; then
	   		cp -a /etc/X11/xorg.conf /etc/X11/.xorg.conf.xgi
			# claire 20080529 add, remove Section Screen Modes
			sh removemodes.sh 
		fi
 	    fi

	# patch /usr/share/hwdata/Cards and /usr/share/hwdata/pcitable
	
	if [ -f /usr/share/hwdata/Cards ] ; then
		echo "Backup original Cards Information..."
		cp /usr/share/hwdata/Cards /usr/share/hwdata/Cards.backup.xgi
		echo "Add XGI Cards Information..."
		perl xgicfg_redhat.plx -f "/usr/share/hwdata/Cards" -a "$XGICards" -t Cards
		cp /usr/share/hwdata/Cards.new /usr/share/hwdata/Cards
	fi
	
	if [ -f /usr/share/hwdata/pcitable ] ; then
		echo "Backup original pcitable Information..."
		cp /usr/share/hwdata/pcitable /usr/share/hwdata/pcitable.backup.xgi
		echo "Add XGI pcitable Information..."
		perl xgicfg_redhat.plx -f "/usr/share/hwdata/pcitable" -a "$XGIPCI" -t pcitable
		cp /usr/share/hwdata/pcitable.new /usr/share/hwdata/pcitable	
	fi
	
	SYSTEM_CONFIG_DISPLAY="/usr/bin/system-config-display"
	CONFIG_DISPLAY_RH_XF86="/usr/bin/redhat-config-xfree86"
	CONFIG_DISPLAY_RH_XORG="/usr/bin/redhat-config-xorg"
	
	if [ -f $CONFIG_DISPLAY_RH_XORG ] ; then
		SYSTEM_CONFIG_DISPLAY=$CONFIG_DISPLAY_RH_XORG
	elif [ -f $CONFIG_DISPLAY_RH_XF86 ] ; then
		SYSTEM_CONFIG_DISPLAY=$CONFIG_DISPLAY_RH_XF86
	fi
	
	if [ -f $SYSTEM_CONFIG_DISPLAY ] ; then
		#Jong Lin 07/27/2005; call config command just for RedHat
		if [ "$Distrib" = "redhat" ] ; then
			echo "run x configuration..using $SYSTEM_CONFIG_DISPLAY"

		#Jong Lin 07/27/2005; Treat Fedora as other distribution
		#if [ "$Distrib" = "fedora" ] && [ "$MACH" = "i386" ] ; then
		#	$SYSTEM_CONFIG_DISPLAY --reconfig --noui 
		#else

			$SYSTEM_CONFIG_DISPLAY --reconfig --noui
			echo "X configuration has been modified"
		fi

	else
		echo "$SYSTEM_CONFIG_DISPLAY does not exist. Please run xf86config."	
	fi

	# Probe HW and generate /etc/sysconfig/hwconf
	if [ -f /usr/sbin/kudzu ] ; then
		kudzu -q
	fi
	
	echo "Finish"

	# Jong Lin 07/27/2005; Treat Fedora as other distribution
	# Force to modify configuration file
	if [ "$Distrib" = "redhat" ] ; then
		exit 0
	fi
	fi
fi

##
# Finish Redhat X configuration
##

#================================================================

##
# SuSE Begin
##

if [ "$Distrib" = "suse" ] ; then
	# patch /usr/X11/lib/sax/api/data/cdb/Cards
	# patch /usr/X11/lib/sax/sysp/maps/Identity.map
	# patch /usr/X11/lib/sax/sysp/maps/Vendor.map
	#CARDS=/usr/X11/lib/sax/api/data/cdb/Cards
	#IDENTITY=/usr/X11/lib/sax/sysp/maps/Identity.map
	#VENDOR=/usr/X11/lib/sax/sysp/maps/Vendor.map
		
	#if [ "$MACH" = "x86_64" ] ; then
	#	CARDS=/usr/X11/lib64/sax/api/data/cdb/Cards
	#	IDENTITY=/usr/X11/lib64/sax/sysp/maps/Identity.map
	#	VENDOR=/usr/X11/lib64/sax/sysp/maps/Vendor.map
	#fi
	
	#
	# Get major version of SuSE
	#
#	ver_full_suse=`grep ^SuSE /etc/SuSE-release | cut -d ' ' -f3`
         
		if [ ${#V} -gt 0 ] ; then
		if [ $V -ge 6 ] ; then
         if [ $V1 -ge 9 ] ; then
			cp -a /etc/X11/xorg.conf /etc/X11/.xorg.conf.xgi
			# claire 20080529 add, remove Section Screen Modes
	#		sh removemodes.sh 
			#if [ $ver_full_suse="Enterprise" ]; then
	    		CARDS=/usr/share/sax/api/data/cdb/Cards
		        IDENTITY=/usr/share/sax/sysp/maps/Identity.map
            		VENDOR=/usr/share/sax/sysp/maps/Vendor.map
			if [ "$MACH" = "x86_64" ] ; then
 		   		CARDS=/usr/share/sax/api/data/cdb/Cards
		   		IDENTITY=/usr/share/sax/sysp/maps/Identity.map
		   		VENDOR=/usr/share/sax/sysp/maps/Vendor.map
			fi
                    fi
                fi
  	else	    
		ver_full_suse=`grep ^SuSE /etc/SuSE-release | cut -d ' ' -f3`
		ver_suse=$ver_full_suse

        
		#if [ `expr index $ver_full_suse '.'` > 0 ]; then
	    	#ver_suse=`echo $ver_full_suse|cut -d '.' -f1`
        	#i
   
    
		CARDS=/usr/X11/lib/X11/Cards
		IDENTITY=/usr/share/sax/sysp/maps/Identity.map
		VENDOR=/usr/share/sax/sysp/maps/Vendor.map
	 
		if [ "$MACH" = "x86_64" ] ; then
			CARDS=/usr/X11/lib64/X11/Cards
		fi

		if [ $ver_full_suse -ge 10 ]; then
			CARDS=/usr/X11/lib/sax/api/data/cdb/Cards
			IDENTITY=/usr/X11/lib/sax/sysp/maps/Identity.map
			VENDOR=/usr/X11/lib/sax/sysp/maps/Vendor.map
			if [ "$MACH" = "x86_64" ] ; then
				CARDS=/usr/X11/lib64/sax/api/data/cdb/Cards
				IDENTITY=/usr/X11/lib64/sax/sysp/maps/Identity.map
				VENDOR=/usr/X11/lib64/sax/sysp/maps/Vendor.map
			fi
		fi	
	fi
	
src="/tmp/test.map"
des="/tmp/test.map.bak"
cp $IDENTITY $IDENTITY.backup.xgi
cp $IDENTITY $src
cp $IDENTITY $des
	
	a=`grep -n 'DID=0x0020' $src|cut -d ':' -f1`

while [ "${#a}" -gt 0 ]
do
#echo $a
	b=`echo $a|cut -d ' ' -f1`
	
	i=$b
	
	sed ""$b","$i"d" $src > $des

	tmp=$src
	src=$des
	des=$tmp
	test=
	a=`grep -n 'DID=0x0020' $src|cut -d ':' -f1`
done
	
	cp $src $IDENTITY
	
	if [ -f $CARDS ] ; then
		echo "Backup original Cards Information..."
		cp $CARDS $CARDS.backup.xgi
		echo "Add XGI Cards Information..."
		perl xgicfg_suse.plx -f "$CARDS" -a "$XGICards_SUSE" -t Cards
		cp $CARDS.new $CARDS
	fi
	
	if [ -f $IDENTITY ] ; then
		echo "Backup original Identity.map Information..."
		cp $IDENTITY $IDENTITY.backup.xgi
		echo "Add XGI identity Information..."
		perl xgicfg_suse.plx -f "$IDENTITY" -a "$XGIIdentity" -t identity
		cp $IDENTITY.new $IDENTITY
	fi

	
	if [ -f $VENDOR ] ; then
		echo "Backup original Vendor.map Information..."
		cp $VENDOR $VENDOR.backup.xgi
		echo "Add XGI Vendor Information..."
		perl xgicfg_suse.plx -f "$VENDOR" -a "Vendor.xgi" -t vendor
		cp $VENDOR.new $VENDOR
	fi

	SYSTEM_CONFIG_DISPLAY="/usr/X11/bin/sax2"
	
	if [ -f $SYSTEM_CONFIG_DISPLAY ] ; then
           cp -a /etc/X11/xorg.conf /etc/X11/.xorg.conf.xgi	
		echo "run x configuration...using $SYSTEM_CONFIG_DISPLAY"
		CHIPNO=`$SYSTEM_CONFIG_DISPLAY -p |grep 0x18ca | sed 's/is.*$//g' |sed 's/Chip://g'`
		$SYSTEM_CONFIG_DISPLAY -u -a -c $CHIPNO
		# claire 20080529 add, remove Section Screen Modes
		  sh removemodes.sh
		echo "finished."
	else
		echo "$SYSTEM_CONFIG_DISPLAY does not exist. Please run xf86config."	
	fi 
	exit 0

fi

##
# SuSE End
##

#================================================================

##
# Mandrake Begin
## 

if [ "$Distrib" = "mandrake" ] ; then
	# patch /usr/share/ldetect-lst/Cards+
	# patch /usr/share/ldetect-lst/pcitable

	if [ -f /usr/share/ldetect-lst/Cards+ ] ; then
		echo "Backup original Cards Information..."
		cp /usr/share/ldetect-lst/Cards+ /usr/share/ldetect-lst/Cards+.backup.xgi
		echo "Add XGI Cards Information..."
		perl xgicfg_mandrake.plx -f "/usr/share/ldetect-lst/Cards+" -a "$XGICards" -t Cards
		cp /usr/share/ldetect-lst/Cards+.new /usr/share/ldetect-lst/Cards+
	fi
	
	if [ -f /usr/share/ldetect-lst/pcitable ] ; then
		echo "Backup original pcitable Information..."
		cp /usr/share/ldetect-lst/pcitable /usr/share/ldetect-lst/pcitable.backup.xgi
		echo "Add XGI pcitable Information..."
		perl xgicfg_mandrake.plx -f "/usr/share/ldetect-lst/pcitable" -a "$XGIPCI" -t pcitable
		cp /usr/share/ldetect-lst/pcitable.new /usr/share/ldetect-lst/pcitable	
	fi
	
	# next step, configure XF86Config/xorg.conf directly

fi


##
# Mandrake End
##


#===============================================================

##
# RedFlag Begin
## 

if [ "$Distrib" = "redflag" ] ; then
	# patch /usr/share/hwdata/Cards and /usr/share/hwdata/pcitable
	
	if [ -f /usr/share/hwdata/Cards ] ; then
		echo "Backup original Cards Information..."
		cp /usr/share/hwdata/Cards /usr/share/hwdata/Cards.backup.xgi
		echo "Add XGI Cards Information..."
		perl xgicfg_redhat.plx -f "/usr/share/hwdata/Cards" -a "$XGICards" -t Cards
		cp /usr/share/hwdata/Cards.new /usr/share/hwdata/Cards
	fi
	
	if [ -f /usr/share/hwdata/pcitable ] ; then
		echo "Backup original pcitable Information..."
		cp /usr/share/hwdata/pcitable /usr/share/hwdata/pcitable.backup.xgi
		echo "Add XGI pcitable Information..."
		perl xgicfg_redhat.plx -f "/usr/share/hwdata/pcitable" -a "$XGIPCI" -t pcitable
		cp /usr/share/hwdata/pcitable.new /usr/share/hwdata/pcitable	
	fi

	#
	# JIll, 2006/08/16
	# Miracle patch solution	
	#
	if [ -f /usr/share/hwdata/pcitable.old ] ; then
		echo "Backup original pcitable.old Information..."
		cp /usr/share/hwdata/pcitable.old /usr/share/hwdata/pcitable.old.backup.xgi
		echo "Add XGI pcitable.old Information..."
		perl xgicfg_redhat.plx -f "/usr/share/hwdata/pcitable.old" -a "$XGIPCI" -t pcitable.old
		cp /usr/share/hwdata/pcitable.new /usr/share/hwdata/pcitable.old	
	fi

	
	# next step, configure XF86Config/xorg.conf directly

fi


##
# RedFlag End
##


#===============================================================

#
# Other distributions
#
	XFREE86_CFG="/etc/X11/XF86Config"
	XFREE86_BAK="/etc/X11/.XF86Config.bak"
	
	XORG_CFG="/etc/X11/xorg.conf"
	#XORG_BAK="/etc/X11/.xorg.conf.bak"
	XORG_BAK="/etc/X11/.xorg.conf.xgi"
	
	RF_XFREE86_CFG="/etc/X11/XF86Config-4"
	RF_XFREE86_BAK="/etc/X11/.XF86Config-4.bak"
	
	CFG=$XFREE86_CFG
	BAK=$XFREE86_BAK
	
	if [ -f $XFREE86_CFG ] ; then
		CFG=$XFREE86_CFG
		BAK=$XFREE86_BAK
		XSERVER_MODULE="XFree86"
	fi
	
	if [ -f $XORG_CFG ] ; then
		CFG=$XORG_CFG
		BAK=$XORG_BAK
		XSERVER_MODULE="XOrg"
                #claire 20080529 add, remvoe Section Screen Modes
		sh removemodes.sh
        elif [ $Distrib = "FreeBSD" ] ; then
                if [ -f /root/xorg.conf.new ] ; then
                   cp /root/xorg.conf.new $XORG_CFG
                   CFG=$XORG_CFG
                   BAK=$XORG_BAK
                   XSERVER_MODULE="XOrg"               
                   #claire 20080529 add, remvoe Section Screen Modes
		    sh removemodes.sh
                   
		fi
	fi

	if [ -f $RF_XFREE86_CFG ] ; then
		CFG=$RF_XFREE86_CFG
		BAK=$RF_XFREE86_BAK
		XSERVER_MODULE="XFree86"
	fi
	
	#
# Jill, 2006/9/27
# Remove all "Device" Section before add XGI device Section
#
src="/tmp/conf.tmp"
des="/tmp/conf.tmp.bak"


	if [ $Distrib = "FreeBSD" ] ; then
		install  -m 755 $CFG $src
		install  -m 755 $CFG $des
		cp $CFG /etc/X11/.xorg.conf.xgi
	fi

	if [ $Distrib != "FreeBSD" ] ; then 
			install -D -m 755 $CFG $src
			install -D -m 755 $CFG $des
	fi


a=`grep -n '^Section "Device"' $src|cut -d ':' -f1`

while [ "${#a}" -gt 0 ]
do

	b=`echo $a|cut -d ' ' -f1`
	
	i=$b
	while [ "$test" != "EndSection" ]
	do
		test=`sed -n -e "$i"p $src`
		#echo "$test"
		i=$(($i+1))	
	done
	i=$(($i-1))	
	
	sed ""$b","$i"d" $src > $des

	tmp=$src
	src=$des
	des=$tmp
	test=
	a=`grep -n '^Section "Device"' $src|cut -d ':' -f1`
done

#
# add Device Section for XGI drivers
#
echo $XGICards	
	
	#echo "$CFG $BAK"	
	#perl xgicfg.plx $CFG $BAK
	echo "Modify $CFG ..."
	xgicard=`cat $XGICards | grep ^NAME | cut -d " " -f4`
	xgidrv=`cat $XGICards | grep ^DRIVER | cut -d " " -f2`
	perl xgicfg.plx $src $BAK $xgicard $xgidrv	
	
if [ ! -f $src ] ; then
	echo "Cannot find X configuration file $CFG . Please run xorgconfig for XOrg or xf86config for Xfree." 1>&2 
	exit -1 ;
fi

mv $CFG $BAK
mv $src $CFG
	
# Finish Configuration


