#!/bin/sh

SYSTEM=`uname -s`
CURRENTDATE=`date +%F-%H-%M-%N`
echo
echo "XGI $SYSTEM driver installation for package `cat version`"
echo 

#############################################
## 0. Get the distribution information
#############################################
Distrib_SL="/etc/slackware-version"
Distrib="other"

#check OS
if [ -f $Distrib_SL ] ; then
	Distrib="Slackware"
	Slackware12=`grep -i "Slackware" /etc/slackware-version |cut -d ' ' -f2`

else 
	Distrib="other"
fi

echo $Distrib


  configother=/etc/X11/.xorg.conf.xgi                                                           
  if [ -f $configother ] ; then                                                                 
     echo "Driver has alreday setup, Please make uninstall first and then reinstallate."        
     exit 0                                                                                     
  fi                                                                                            
                                                                                                

#############################################
## 1. Copy 2D driver
#############################################
driver_bin="xgiz_drv.o"
driver_share_bin="xgiz_drv.so"


if [ ! -d xgiz_drv.so ] ; then
	cp -a xgiz_drv.so.70  xgiz_drv.so
fi

X -version 2&>/root/xgi.log
Ver=`grep -i "X Window System Version" /root/xgi.log|cut -d ' ' -f5`
V=`echo $Ver|cut -d '.' -f1`
V1=`echo $Ver|cut -d '.' -f2`


if [ ${#Slackware12} -gt 0 ] ; then               
        #echo ${#Slackware12}
	cp -a xgiz_drv.so.72 xgiz_drv.so      
        X11R7=/usr/lib/xorg/modules/drivers
fi        

if [ "$X11R6" = "" ] ; then
	# echo "The system do not contains the X11R6 environment variable." 1>&2
	# echo "Use /usr/X11R6 as default X11R6 path." 1>&2
	# echo
	# echo
	X11R6=/usr/X11R6
	export X11R6
fi

if [ "$MACHTYPE" = "" ] ; then
	MACHTYPE=i386
fi

MACH=`echo $MACHTYPE | sed 's/-.*$//g'` ;

if [ "$MACH" = "x86_64" ] ; then
	# 64 bit
	driver_path=${X11R6}/lib64/modules/drivers
	if [ ${#V} -gt 0 ] ; then
	   if [ $V -ge 7 ] ; then
		X11R7=/usr/lib64/xorg/modules/drivers
		driver_path=${X11R7}
		driver_bin="xgiz_drv.so"
	   elif [ $V -ge 6 ] ; then
		if [ $V1 -ge 9 ] ;then
		driver_bin="xgiz_drv.so"
                fi
           fi
        fi
       
	if [ ! -d $driver_path ] ; then
		driver_path=${X11R6}/lib/modules/drivers
	fi
else
	# 32 bit	
	 driver_path=${X11R6}/lib/modules/drivers

    
    if [ ${#Slackware12} -gt 0 ] ; then               
#        echo ${#Slackware12}
	cp -a xgiz_drv.so.72 xgiz_drv.so      
        X11R7=/usr/lib/xorg/modules/drivers
	driver_bin=xgiz_drv.so
    fi        
fi  
rm -rf /root/xgi.log
    
DRV="${driver_path}/$driver_bin"
SHARE_DRV="${driver_path}/$driver_share_bin"

if [ ! -d "$driver_path" ] ; then
	echo "Cannot open X11 installation path $driver_path. Exit." 1>&2
	exit -1 ;
fi

if [ -f $driver_bin ] ; then 
	install -m 644 $driver_bin $driver_path
	echo "Driver $driver_bin copy to ${driver_path} done."
else
	echo "There is no $driver_bin existing." 1>&2
	exit -1 ;
fi


# Probe HW and generate /etc/sysconfig/hwconf
if [ -f /usr/sbin/kudzu ] ; then
	kudzu -q
fi

################################################
## 2. Get XGI chip information
################################################
#
# Get register info.to check if the current 
# adapter is XG20 or XG21, 2005/11/1, JILL
#

XGICards="Cards.xgi"
XGIPCI="pcitable.xgi"
XGICards_SUSE="Cards.xgi.suse"
XGIIdentity="Identity.xgi"

if [ $Distrib != "FreeBSD" ] ; then 

	lspci -n >/root/xgichip.log
	#b=`grep -i "18ca:0020" /root/xgichip.log|cut -d ' ' -f3`
	#c=`grep -i "18ca:0027" /root/xgichip.log|cut -d ' ' -f3`

	b=`grep -i "18ca:0020" /root/xgichip.log`
	c=`grep -i "18ca:0027" /root/xgichip.log`
	d=`grep -i "18ca:0021" /root/xgichip.log`
	#echo $b
else
	XGICards="Cards_Freebsd.xgi"
	XGIPCI="pcitable_Freebsd.xgi"
	XGIIdentity="Identity_Freebsd.xgi"
fi                                  

                                             

if [ $Distrib != "FreeBSD" ] ; then
	if [ ${#b} -gt 0 ] ; then
	#if [ $b = "18ca:0020" ] ; then
				XGICards="Cards_21.xgi"
				XGIPCI="pcitable_21.xgi"
				XGICards_SUSE="Cards_21.xgi.suse"
				XGIIdentity="Identity_21.xgi"
	fi

	if [ ${#d} -gt 0 ] ; then
				XGICards="Cards_21.xgi"
				XGIPCI="pcitable_21.xgi"
				XGICards_SUSE="Cards_21.xgi.suse"
				XGIIdentity="Identity_21.xgi"
	fi

	if [ ${#c} -gt 0 ] ; then
	#if [ $c = "18ca:0027" ] ; then
		XGICards="Cards_27.xgi"
		XGIPCI="pcitable_27.xgi"
		XGICards_SUSE="Cards_27.xgi.suse"
		XGIIdentity="Identity_27.xgi"

	fi



fi


################################################
## 3. modify configuration
################################################


#
# Other distributions
#
	XFREE86_CFG="/etc/X11/XF86Config"
	XFREE86_BAK="/etc/X11/.XF86Config.bak"
	
	XORG_CFG="/etc/X11/xorg.conf"
#	XORG_BAK="/etc/X11/.xorg.conf.bak"
	XORG_BAK="/etc/X11/.xorg.conf.xgi"
		
	RF_XFREE86_CFG="/etc/X11/XF86Config-4"
	RF_XFREE86_BAK="/etc/X11/.XF86Config-4.bak"
	
	CFG=$XFREE86_CFG
	BAK=$XFREE86_BAK
	
	if [ -f $XFREE86_CFG ] ; then
		CFG=$XFREE86_CFG
		BAK=$XFREE86_BAK
		XSERVER_MODULE="XFree86"
	fi
	
	if [ -f $XORG_CFG ] ; then
		CFG=$XORG_CFG
		BAK=$XORG_BAK
		XSERVER_MODULE="XOrg"
        elif [ $Distrib = "FreeBSD" ] ; then
                if [ -f /root/xorg.conf.new ] ; then
                   cp /root/xorg.conf.new $XORG_CFG
                   CFG=$XORG_CFG
                   BAK=$XORG_BAK
                   XSERVER_MODULE="XOrg"               
                fi
	fi

	if [ -f $RF_XFREE86_CFG ] ; then
		CFG=$RF_XFREE86_CFG
		BAK=$RF_XFREE86_BAK
		XSERVER_MODULE="XFree86"
	fi
	
	#
# Jill, 2006/9/27
# Remove all "Device" Section before add XGI device Section
#
src="/tmp/conf.tmp"
des="/tmp/conf.tmp.bak"


	install -D -m 755 $CFG $src
	install -D -m 755 $CFG $des


a=`grep -n '^Section "Device"' $src|cut -d ':' -f1`

while [ "${#a}" -gt 0 ]
do

	b=`echo $a|cut -d ' ' -f1`
	
	i=$b
	while [ "$test" != "EndSection" ]
	do
		test=`sed -n -e "$i"p $src`
		#echo "$test"
		i=$(($i+1))	
	done
	i=$(($i-1))	
	
	sed ""$b","$i"d" $src > $des

	tmp=$src
	src=$des
	des=$tmp
	test=
	a=`grep -n '^Section "Device"' $src|cut -d ':' -f1`
done

#
# add Device Section for XGI drivers
#
	
	
	#echo "$CFG $BAK"	
	#perl xgicfg.plx $CFG $BAK
	echo "Modify $CFG ..."
	xgicard=`cat $XGICards | grep ^NAME | cut -d " " -f4`
	xgidrv=`cat $XGICards | grep ^DRIVER | cut -d " " -f2`
	perl xgicfg.plx $src $BAK $xgicard $xgidrv	
	
if [ ! -f $src ] ; then
	echo "Cannot find X configuration file $CFG . Please run xorgconfig for XOrg or xf86config for Xfree." 1>&2 
	exit -1 ;
fi

mv $CFG $BAK
mv $src $CFG

sh removemodes.sh
	
# Finish Configuration


