#!/usr/bin/perl

# $debug = 1 ;

#$File_Cards="/usr/share/hwdata/Cards.new";
#$File_pcitable="usr/share/hwdata/pcitable.new";

#$XGI_Cards="Cards.xgi";
#$XGI_pcitable="pcitable.xgi";

($filetype, $old_file, $append_file) = &ParseArgv(@ARGV) ;

if ( $filetype eq "Cards" ){
	append_cards();	
} elsif ( $filetype eq "pcitable"){
	append_pcitable();
	
} elsif ($filetype eq "vendor") {
	append_vendor();
} elsif ($filetype eq "identity" ) {
	append_identity();
}
 
exit(0);

sub append_vendor() {
        open( OLD_CFG , "$old_file" ) || die "Cannot open $old_file." ;
        open( APPEND_CFG , "$append_file" ) || die "Cannot open $append_file." ;

        @append_content = () ;
        while( <APPEND_CFG> ){
                chop ;
                $str = $_ ;
                push( @append_content, $str ) ;
	}

	$newscript = "$old_file.new";
	
	if( ! open( NEW_CFG , ">$newscript" )){
		close( OLD_CFG ) ;
		close( APPEND_CFG );
		local( $str ) = sprintf( "Cannot open %s\n", $newscript ) ;
		die $str ;
	}

	while( <OLD_CFG> ){
		chop ;
		$str = $_ ;
        if( $str !=~ m/^\#/ ){
        	$vendor_device=substr($str,0,6);
            $match = 0;
            $idx = 0;
            foreach $aline ( @append_content ){
            	$vendor_device2=substr($aline,0,6);
				if ( ($vendor_device eq $vendor_device2) && ($match == 0) ) { # replace this section with the section in append file
					$match = 1;
					last;
				} else {
					$idx = $idx + 1;
				}
			}
			if ( $match == 1 ) {
				print NEW_CFG "$append_content[$idx]\n";
				$append_content[$idx] = "deleted";
			} else {
				print NEW_CFG "$str\n";
			}
		} else {
			print NEW_CFG "$str\n";
		}
		
	}
	foreach $aline ( @append_content ){
		if ( ($aline ne "deleted") && ($aline !=~ m/^\#/) ) {
			print NEW_CFG "$aline\n";
		}
	}
	close( OLD_CFG ) ;
	close( APPEND_CFG );
	close( NEW_CFG );	
	
}

sub append_identity() {
        open( OLD_CFG , "$old_file" ) || die "Cannot open $old_file." ;
        open( APPEND_CFG , "$append_file" ) || die "Cannot open $append_file." ;

        @append_content = () ;
        while( <APPEND_CFG> ){
                chop ;
                $str = $_ ;
                push( @append_content, $str ) ;
	}

	$newscript = "$old_file.new";
	
	if( ! open( NEW_CFG , ">$newscript" )){
		close( OLD_CFG ) ;
		close( APPEND_CFG );
		local( $str ) = sprintf( "Cannot open %s\n", $newscript ) ;
		die $str ;
	}

	while( <OLD_CFG> ){
		chop ;
		$str = $_ ;
        #if( $str =~ m/VID=(.*)DID=(.*)$/ ){
        if( $str =~ m/VID=(.*)DID=(.*)SERVER/ ){
        	$vendorID=$1;
		$deviceID=$2;
		#print STDERR "1: $vendorID, $deviceID\n";
            $match = 0;
            $idx = 0;
            foreach $aline ( @append_content ){
            	$tmp = $aline;
		if ($tmp =~ m/VID=(.*)DID=(.*)SERVER/) {
                	$vendorID2=$1;
                	$deviceID2=$2;
                	#print STDERR "2: $vendorID2, $deviceID2\n";
		} else {
			$vendorID2="";
			$deviceID2="";
		}
		if ( ($vendorID eq $vendorID2) && ($deviceID eq $deviceID2)&& ($match == 0) ) { # replace this section with the section in append file
					$match = 1;
					last;
				} else {
					$idx = $idx + 1;
				}
			}
			if ( $match == 1 ) {
				print NEW_CFG "$append_content[$idx]\n";
				$append_content[$idx] = "deleted";
			} else {
				print NEW_CFG "$str\n";
			}
		} else {
			print NEW_CFG "$str\n";
		}
		
	}
	foreach $aline ( @append_content ){
		if ( ($aline ne "deleted") && ($aline !=~ m/^\#/) ) {
			print NEW_CFG "$aline\n";
		}
	}
	close( OLD_CFG ) ;
	close( APPEND_CFG );
	close( NEW_CFG );	

}

sub append_cards() {
	open( OLD_CFG , "$old_file" ) || die "Cannot open $old_file." ;
	open( APPEND_CFG , "$append_file" ) || die "Cannot open $append_file." ;

	@append_content = () ;
	while( <APPEND_CFG> ){
		chop ;
		$str = $_ ;
		push( @append_content, $str ) ;
	}
	
	$newscript = "$old_file.new";
	
	if( ! open( NEW_CFG , ">$newscript" )){
		close( OLD_CFG ) ;
		close( APPEND_CFG );
		local( $str ) = sprintf( "Cannot open %s\n", $newscript ) ;
		die $str ;
	}
	
	$section_begin=0;
	$FIELD_NAME="";
	@section_content = () ;
	
	while( <OLD_CFG> ){
		chop ;
		$str = $_;
		if( $str =~ m/(.*){$/ ){
			$FIELD_NAME=$str;
			#print STDERR "1: $FIELD_NAME\n";
			$section_begin=1;
			push( @section_content, $str ) ;
		} elsif ( ($str eq "}") && ($section_begin==1)) { #blank line
			$section_begin=0;
			push( @section_content, "" ) ;
			#check if the name is existing in append file
			$match = 0;
			$idx = 0;
			foreach $aline ( @append_content ){
				if ( ($FIELD_NAME eq $aline) && ($match == 0) ) { # replace this section with the section in append file
					$match = 1;
					last;
				} else {
					$idx = $idx + 1;
				}
			}
			if ( $match == 1) {
				while ($append_content[$idx] ne "")
				{	
					print NEW_CFG "$append_content[$idx]\n";
					$append_content[$idx] = "deleted";
					$idx = $idx + 1;
				}
				print NEW_CFG "\n"; #blank line
				$match = 0;
			} else {
				foreach $line ( @section_content ){
					print NEW_CFG "$line\n";
				}
				@section_content = () ; #clear, for next section
			}
			$FIELD_NAME="";
		} elsif ( ($str =~ m/^\#/) && ($section_begin==0) ) { #comment
			print NEW_CFG "$str\n";
		} else {
			push( @section_content, $str ) ;
		}					
	}
	foreach $aline ( @append_content ){
		if ( ($aline ne "deleted") && ($aline !=~ m/^\#/) ) {
			print NEW_CFG "$aline\n";
		}
	}
	close( OLD_CFG ) ;
	close( APPEND_CFG );
	close( NEW_CFG );
}		

sub append_pcitable() {
	open( OLD_CFG , "$old_file" ) || die "Cannot open $old_file." ;
	open( APPEND_CFG , "$append_file" ) || die "Cannot open $append_file." ;

	@append_content = () ;
	while( <APPEND_CFG> ){
		chop ;
		$str = $_ ;
		push( @append_content, $str ) ;
	}
	
	$newscript = "$old_file.new";
	
	if( ! open( NEW_CFG , ">$newscript" )){
		close( OLD_CFG ) ;
		close( APPEND_CFG );
		local( $str ) = sprintf( "Cannot open %s\n", $newscript ) ;
		die $str ;
	}
	while( <OLD_CFG> ){
		chop ;
		$str = $_ ;
        if( $str !=~ m/^\#/ ){
        	$vendor_device=substr($str,0,13);
            $match = 0;
            $idx = 0;
            foreach $aline ( @append_content ){
            	$vendor_device2=substr($aline,0,13);
				if ( ($vendor_device eq $vendor_device2) && ($match == 0) ) { # replace this section with the section in append file
					$match = 1;
					last;
				} else {
					$idx = $idx + 1;
				}
			}
			if ( $match == 1 ) {
				print NEW_CFG "$append_content[$idx]\n";
				$append_content[$idx] = "deleted";
			} else {
				print NEW_CFG "$str\n";
			}
		} else {
			print NEW_CFG "$str\n";
		}
		
	}
	foreach $aline ( @append_content ){
		if ( ($aline ne "deleted") && ($aline !=~ m/^\#/) ) {
			print NEW_CFG "$aline\n";
		}
	}
	close( OLD_CFG ) ;
	close( APPEND_CFG );
	close( NEW_CFG );	
	
}		

sub ParseArgv {
	
	local( @argv ) = @_ ;
	local( $type, $scriptname1, $scriptname2 ) ;

	while( $#argv >= 0 ){
		$arg = shift( @argv ) ;

		if( $arg =~ m/^-[fF]/ ){
			$scriptname1 = shift( @argv ) ;
			$scriptname1 = "" if( ! -f $scriptname1 ) ;
		}elsif( $arg =~ m/^-[aA?]/ ){
			$scriptname2 = shift( @argv ) ;
			$scriptname2 = "" if( ! -f $scriptname2 ) ;			
		}elsif( $arg =~ m/^-[tT?]/ ){
			$type = shift( @argv ) ;
		}elsif( $arg =~ m/^-[Hh?]/ ){
			print STDERR <<EOM if ( $debug ) ;
	
	Usage: perl $0 -f <path of Cards|path of pcitable>
				   -A <append file name> 
	               -h show this screen
EOM
			exit(0) ;
		}
	}

	return $type, $scriptname1, $scriptname2;
}
